(use sxml.serializer)
(define main (lambda (args)
	(call-with-output-file "index.html"
		(lambda (out)
			(display "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" out)
			(newline out)
			(display "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"" out)
			(newline out)
			(display "\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">" out)
			(newline out)
			(srl:sxml->xml
				`(html (@ (xmlns "http://www.w3.org/1999/xhtml") (xml:lang "ja"))
					(head
						(meta (@ (http-equiv "Content-Type") (content "text/html; charset=UTF-8")))
						(meta (@ (http-equiv "Content-Language") (content "ja")))
						(link (@ (rel "shortcut icon") (href "favicon.ico") (type "image/x-icon")))
						(link (@ (rel "stylesheet") (type "text/css") (href "index.css")))
						(title "Scheme-users.jp - 日本の Scheme ユーザのためのハブサイト"))
					(body
						(p (@ (style "margin-left:0;")) "(" (a (@ (href "http://scheme-users.jp/")) "scheme-users.jp") ")")

						(h1 "日本の Scheme ユーザのためのハブサイト")

						(p (a (@ (href "http://conferences.yapcasia.org/ya2008/") (title "YAPC::Asia 2008 - May 15-16th in Tokyo, JAPAN")) "YAPC::Asia 2008")
							" で " (a (@ (href "http://conferences.yapcasia.org/ya2008/user/780") (title "ユーザ情報: YAPC::Asia 2008 - May 15-16th in Tokyo, JAPAN")) "Michael Schwern")
							" は「SEO に有効な独自ドメインを取って、もっと Perl 初心者が集まりやすい nice な Perl の情報を集めたサイトを作れ！」といったそうです。"
							"そして「" (a (@ (href "http://perl-users.jp")) "Perl-users.jp - 日本のPerlユーザのためのハブサイト") "」ができました。")
						(p "これは Scheme も同じではないのか？"
							"そう思って scheme-users.jp ドメインを取り、ここに scheme-users.jp を開始します。"
							"完全に perl-users.jp とか js-users.jp とか as-users.jp とかにインスパイアされています。"
							"本当にありがとうございます。" "ノープランです。")

						(h2 "ポリシー的な物")
						(ul
							(li "日本語とＳ式で語り合う。")
							(li "このサイトの想定する利用者層は、超初心者から超上級者まで。")
							(li "たとえば " (a (@ (href "http://www.r6rs.org/")) "R6RS")
								" で、いきなり言語仕様が変更されたとしても、"
								"しっかり初心者層にリーチし、最新のトレンドに近づけるように。")
							(li "Users ってついてるけど、日本人は Users ってついてるものが好きだからという理由だけなので "
								(a (@ (href "http://schemers.org/")) "schemers.org") " とか "
								(a (@ (href "http://practical-scheme.net/wiliki/wiliki.cgi")) "WiLiKi")
								" とかそういうのと競合になるとかスピンアウトしたとかそういうのではありません。"
								"レイヤーが違います。"))

						(h2 "Scheme NEWS")
						(ul
							(li (span (@ (class "date")) "2008/06/07(SAT)") " : 本日 6月7日(土) 午後8時より " (a (@ (href "http://www.lingr.com/room/gKpArxPn9wi")) "Lingr: COMMON LISP 部屋") " で " (a (@ (href "http://cadr.g.hatena.ne.jp/g000001/20080531/1212235511")) "第2回 突発性CL勉強会@Lingr 8時だョ!全員集合") " が開催されます。")
							(li (span (@ (class "date")) "2008/06/04(WED)") " : " (a (@ (href "http://www.plt-scheme.org/")) "Plt Scheme") " の新バージョン 4.0 が " (a (@ (href "http://blog.plt-scheme.org/2008/06/plt-scheme-version-40-is-coming-soon.html")) "まもなくリリース") " されるようです。")
							(li (span (@ (class "date")) "2008/06/03(TUE)") " : Scheme コミュニティのブログ集 " (a (@ (href "http://scheme-users.jp/planet/")) "Planet Scheme Japan") " を開始しました。" (span (@ (style "color:red;")) "(参加者募集中！)"))
							(li (span (@ (class "date")) "2008/05/30(THU)") " : " "軽量プログラミング言語のイベント " (a (@ (href "http://ll.jus.or.jp/2008/")) "LL Future") " のチケットがローソンチケットにて発売開始しました。")
							(li (span (@ (class "date")) "2008/05/28(WED)") " : " (a (@ (href "http://jp.youtube.com/")) "YouTube") " に " (a (@ (href "http://practical-scheme.net/wiliki/wiliki.cgi?Shiro")) "Shiro") " さんが " (a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche") " について話す " (a (@ (href "http://www.youtube.com/watch?v=WEBOdWyGE3E")) "動画") " が公開されています。")
							(li (span (@ (class "date")) "2008/05/27(TUE)") " : " "Open Tech Press に Scheme 関連記事「" (a (@ (href "http://opentechpress.jp/developer/08/05/27/024252.shtml")) "SCSH (Scheme Shell) スクリプト入門") "」が掲載されています。")
							(li (span (@ (class "date")) "2008/05/25(SUN)") " : " "scheme-users.jp 開設しました。"))
						(p (a (@ (href "http://ll.jus.or.jp/2008/")) (img (@ (src "./images/ll2008.jpg") (alt "LL Future 2008/08/30") (style "border:none;")))))

						(h2 "Lisp/Scheme チャット")
						(ul
							(li (a (@ (href "irc://irc.freenode.net/#Lisp_Scheme")) "irc.freenode.net#Lisp_Scheme") " (UTF-8)"))

						(h2 (a (@ (href "http://scheme-users.jp/planet/")) "Planet Scheme Japan"))
						(p (a (@ (href "http://scheme.dk/planet/")) "Planet Scheme")
							" の " (a (@ (href "http://scheme-users.jp/planet/")) "日本版")
							" を作りたいと考えています。参加者募集中です！"
							" Scheme について書いたブログならどなたでも参加できます。")
						(ul
							(li (a (@ (href "http://d.hatena.ne.jp/higepon/")) "ひげぽん OS とか作っちゃうか Mona-"))
							(li (a (@ (href "http://cadr.g.hatena.ne.jp/g000001/")) "わだば Lisper になる")))

						(h2 "日本でよく使われている処理系")
						(ul
							(li (a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche"))
							(li (a (@ (href "http://code.google.com/p/sigscheme/")) "SigScheme"))
							(li (a (@ (href "http://www.plt-scheme.org/")) "Plt Scheme") " / " (a (@ (href "http://www.plt-scheme.org/software/drscheme/")) "DrScheme") " / " (a (@ (href "http://www.plt-scheme.org/software/mzscheme/")) "MzScheme"))
							(li (a (@ (href "http://www.gnu.org/software/guile/")) "GNU Guile"))
							(li (a (@ (href "http://www.gnu.org/software/mit-scheme/")) "MIT/GNU Scheme"))
							(li (a (@ (href "http://code.google.com/p/mosh-scheme/")) "mosh") " : " (a (@ (href "http://d.hatena.ne.jp/higepon/")) "higepon") " 氏が新しく作りはじめた処理系。期待しましょう :-)"))

						(h2 "初心者向け学習サイト")
						(ul
							(li (a (@ (href "http://www.shido.info/lisp/idx_scm.html")) "もうひとつの Scheme 入門"))
							(li (a (@ (href "http://www.unixuser.org/~euske/doc/scm-sd7/")) "Scheme プログラミング入門"))
							(li (a (@ (href "http://www1.ocn.ne.jp/~scheme/scheme-start.html")) "まったく初めての人のための Scheme"))
							(li (a (@ (href "http://www.sampou.org/scheme/t-y-scheme/t-y-scheme.html")) "独習 Scheme 三週間"))
							(li (a (@ (href "http://www.stdio.h.kyoto-u.ac.jp/~hioki/gairon-enshuu/SchemeNotes/scheme.html")) "Scheme への道")))

						(h2 "定番サイト")
						(ul
							(li (a (@ (href "http://practical-scheme.net/")) "Practical Scheme"))
							(li (a (@ (href "http://www.kahua.org/")) "Kahua Project"))
							(li (a (@ (href "http://karetta.jp/book-cover/gauche-hacks")) "Gaucheプログラミング(立読み版)"))
							(li (a (@ (href "http://schemers.org/")) "schemers.org"))
							(li (a (@ (href "http://srfi.schemers.org/")) "SRFI - Scheme Requests for Implementation"))
							(li (a (@ (href "http://www.r6rs.org/")) "R6RS.Org"))
							(li (a (@ (href "http://swiss.csail.mit.edu/projects/scheme/")) "The Scheme Programming Language"))
							(li (a (@ (href "http://www1.ocn.ne.jp/~scheme/")) "やっぱり Scheme だね"))
							(li (a (@ (href "http://lambda.bugyo.tk/hatena/")) "はてなようせいとまなぶ Scheme の形式的意味論"))
							(li (a (@ (href "http://lambda.bugyo.tk/hatena/r5rs.html")) "はてなようせいとまなぶ R5RS の表示的意味論"))
							(li (a (@ (href "http://www.math.u-toyama.ac.jp/~iwao/Scheme/scheme.html")) "Algorithmic Language Scheme")))
							;;(li (a (@ (href "http://t-code.org/scheme-aa.html")) "ポルナレフ"))

						(h2 "その他の *-users.jp")
						(ul
							(li (a (@ (href "http://air-users.jp/")) "air-users.jp"))
							(li (a (@ (href "http://arc-users.jp/")) "arc-users.jp"))
							(li (a (@ (href "http://as-users.jp/")) "as-users.jp"))
							(li (a (@ (href "http://awk-users.jp/")) "awk-users.jp"))
							(li (a (@ (href "http://cakephp-users.jp/")) "cakephp-users.jp"))
							(li (a (@ (href "http://emacs-users.jp/")) "emacs-users.jp"))
							(li (a (@ (href "http://hauhau-users.jp/")) "hauhau-users.jp"))
							(li (a (@ (href "http://haxe-users.jp/")) "haxe-users.jp"))
							(li (a (@ (href "http://hsp-users.jp")) "hsp-users.jp"))
							(li (a (@ (href "http://io-users.jp/")) "io-users.jp"))
							(li (a (@ (href "http://js-users.jp/")) "js-users.jp"))
							(li (a (@ (href "http://perl-users.jp/")) "perl-users.jp"))
							(li (a (@ (href "http://php-users.jp/")) "php-users.jp"))
							(li (a (@ (href "http://pyobjc-users.jp/")) "pyobjc-users.jp"))
							(li (a (@ (href "http://python-users.jp/")) "python-users.jp"))
							(li (a (@ (href "http://rails-users.jp/")) "rails-users.jp"))
							(li (a (@ (href "http://ruby-users.jp/")) "ruby-users.jp"))
							(li (a (@ (href "http://vim-users.jp/")) "vim-users.jp")))

						(h3 "管理人")
						(p "なにかあれば何らかの手段で "
							"(string-append \"info\" \"@\" \"scheme-users.jp\")"
							" まで連絡ください。")
						(p "文章のライセンスは、特に明記が無い限り全て "
							(abbr (@ (title "Creative Commons Attribution license")) "CC-by")
							" でお願いします。")
						(p "このページは "
							(a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche")
							" の "
							(a (@ (href "http://practical-scheme.net/gauche/man/gauche-refj_148.html")) "sxml.serializer")
							" を使って生成しています。"
							"リポジトリはそのうちどこかに置く予定です。")
						)) out)))))
