(use sxml.serializer)
(define main (lambda (args)
	(call-with-output-file "index.html"
		(lambda (out)
			(display "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" out)
			(newline out)
			(display "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"" out)
			(newline out)
			(display "\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">" out)
			(newline out)
			(srl:sxml->xml
				`(html (@ (xmlns "http://www.w3.org/1999/xhtml") (xml:lang "ja"))
					(head
						(meta (@ (http-equiv "Content-Type") (content "text/html; charset=UTF-8")))
						(meta (@ (http-equiv "Content-Language") (content "ja")))
						(link (@ (rel "shortcut icon") (href "favicon.ico") (type "image/x-icon")))
						(link (@ (rel "stylesheet") (type "text/css") (href "index.css")))
						(title "Scheme-users.jp - 日本の Scheme ユーザのためのハブサイト"))
					(body
						(p (@ (style "margin-left:0;"))
							(a (@ (href "http://scheme-users.jp/"))
								(img (@ (src "./images/top.png") (alt "scheme-users.jp") (style "border:none;")))))

						(h1 "日本の Scheme ユーザのためのハブサイト")

						(p (a (@ (href "http://conferences.yapcasia.org/ya2008/") (title "YAPC::Asia 2008 - May 15-16th in Tokyo, JAPAN")) "YAPC::Asia 2008")
							" で " (a (@ (href "http://conferences.yapcasia.org/ya2008/user/780") (title "ユーザ情報: YAPC::Asia 2008 - May 15-16th in Tokyo, JAPAN")) "Michael Schwern")
							" は「SEO に有効な独自ドメインを取って、もっと Perl 初心者が集まりやすい nice な Perl の情報を集めたサイトを作れ！」といったそうです。"
							"そして「" (a (@ (href "http://perl-users.jp")) "Perl-users.jp - 日本のPerlユーザのためのハブサイト") "」ができました。")
						(p "これは " (strong "Scheme") " も同じではないのか？"
							"そう思って scheme-users.jp ドメインを取り、ここに scheme-users.jp を開始します。"
							"完全に perl-users.jp とか js-users.jp とか as-users.jp とかにインスパイアされています。"
							"本当にありがとうございます。" "ノープランです。")

						(h2 "ポリシー的な物")
						(ul
							(li "日本語とＳ式で語り合う。")
							(li "このサイトの想定する利用者層は、超初心者から超上級者まで。")
							(li "たとえば " (a (@ (href "http://www.r6rs.org/")) "R6RS")
								" で、いきなり言語仕様が変更されたとしても、"
								"しっかり初心者層にリーチし、最新のトレンドに近づけるように。")
							(li "Users ってついてるけど、日本人は Users ってついてるものが好きだからという理由だけなので "
								(a (@ (href "http://schemers.org/")) "schemers.org") " とか "
								(a (@ (href "http://practical-scheme.net/wiliki/wiliki.cgi")) "WiLiKi")
								" とかそういうのと競合になるとかスピンアウトしたとかそういうのではありません。"
								"レイヤーが違います。"))

						(h2 "Scheme NEWS")
						(ul
							(li (span (@ (class "date")) "2008/07/18(FRI)") " : " (a (@ (href "http://code.google.com/p/mosh-scheme/")) "Mosh") " Version 0.0.5 が " (a (@ (href "http://d.hatena.ne.jp/higepon/20080718/1216365536")) "リリース") " されました。R6RS ライブラリの仕組みや syntax-case, syntax-rules などが利用できるようになりました。")
							(li (span (@ (class "date")) "2008/07/17(THU)") " : " (a (@ (href "http://wassr.jp/")) "Wassr") " に " (a (@ (href "http://wassr.jp/channel/gauche")) "Gauche チャンネル") " ができていました。")
							(li (span (@ (class "date")) "2008/07/17(THU)") " : " (a (@ (href "http://wassr.jp/")) "Wassr") " に " (a (@ (href "http://wassr.jp/channel/lisp")) "Lisp チャンネル") " ができていました。")
							(li (span (@ (class "date")) "2008/07/17(THU)") " : " (a (@ (href "http://www.hatena.ne.jp/")) "はてな") " に " (a (@ (href "http://scheme.g.hatena.ne.jp/")) "Scheme グループ") " ができていました。")
							(li (span (@ (class "date")) "2008/07/15(TUE)") " : " (a (@ (href "http://groups.google.co.jp/group/comp.lang.scheme/browse_thread/thread/10aa800ae5d98d19")) "Final SRFI 96: SLIB Prerequisites"))
							(li (span (@ (class "date")) "2008/07/12(SAT)") " : " (a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche") " の拡張ライブラリ " (a (@ (href "http://homepage.mac.com/naoki.koguro/prog/dyncomp/index-j.html")) "dyncomp") " Version 0.1.2 がリリースされました。 MinGW でも動作するようになったようです。")
							(li (span (@ (class "date")) "2008/07/07(MON)") " : " (a (@ (href "http://code.google.com/p/ypsilon/")) "Ypsilon") " Version 0.9.5-update1 が " (a (@ (href "http://lwpinball.wordpress.com/2008/07/07/%e3%81%84%e3%82%84%e3%80%9c%e3%82%aa%e3%83%bc%e3%83%97%e3%83%b3%e3%82%bd%e3%83%bc%e3%82%b9%e3%81%a3%e3%81%a6%e3%81%84%e3%81%84%e3%82%82%e3%81%ae%e3%81%a7%e3%81%99%e3%81%ad%e3%80%9c/")) "リリース") " されました。")
							(li (span (@ (class "date")) "2008/07/07(MON)") " : " (a (@ (href "http://www.plt-scheme.org/")) "Plt Scheme") " Version 4.0.2 がリリースされています。")
							(li (span (@ (class "date")) "2008/07/06(SUN)") " : " (a (@ (href "http://ll.jus.or.jp/2008/")) "LL Future") " の " (a (@ (href "http://ll.jus.or.jp/2008/blog/archives/20")) "Tシャツデザイン") " が公開されました。うしろにあの魚が！")
							(li (span (@ (class "date")) "2008/07/06(SUN)") " : " (a (@ (href "http://d.hatena.ne.jp/higepon/")) "higepon") " さんにより " (a (@ (href "http://srfi.schemers.org/")) "SRFI") " に提案された getenv の仕様が " (a (@ (href "http://srfi.schemers.org/srfi-98/srfi-98.html")) "ドラフト(SRFI-98)") " になりました。")
							(li (span (@ (class "date")) "2008/07/06(SUN)") " : " (a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche") " の拡張ライブラリ " (a (@ (href "http://homepage.mac.com/naoki.koguro/prog/dyncomp/index-j.html")) "dyncomp") " Version 0.1.1 がリリースされました。")
							(li (span (@ (class "date")) "2008/07/04(FRI)") " : CL勉強会の告知を↓のバナー欄に移します。")
							(li (span (@ (class "date")) "2008/06/29(SUN)") " : " (a (@ (href "http://ll.jus.or.jp/2008/")) "LL Future") " にて " (a (@ (href "http://ll.jus.or.jp/2008/lightningtalk")) "Lightning Talk") " の発表者を募集しています。")
							(li (span (@ (class "date")) "2008/06/24(TUE)") " : 6月28日(土) 午後8時より " (a (@ (href "http://www.lingr.com/room/gKpArxPn9wi")) "Lingr: COMMON LISP 部屋") " にて " (a (@ (href "http://cadr.g.hatena.ne.jp/g000001/20080624/1214295121")) "第5回 慢性的CL勉強会@Lingr 8時だョ!全員集合") " が開催されます。")
							(li (span (@ (class "date")) "2008/06/23(MON)") " : " (a (@ (href "http://www.plt-scheme.org/")) "Plt Scheme") " Version 4.0.1 が " (a (@ (href "http://blog.plt-scheme.org/2008/06/plt-scheme-v401.html")) "リリース") " されました。")
							(li (span (@ (class "date")) "2008/06/18(WED)") " : 6月21日(土) 午後8時より " (a (@ (href "http://www.lingr.com/room/gKpArxPn9wi")) "Lingr: COMMON LISP 部屋") " にて " (a (@ (href "http://cadr.g.hatena.ne.jp/g000001/20080618/1213721991")) "第4回 慢性的CL勉強会@Lingr 8時だョ!全員集合") " が開催されます。")
							(li (span (@ (class "date")) "2008/06/16(MON)") " : Gauchebox-0.8.13-box2.exe がリリースされました。 Windows 環境向けに Meadow(Emacs) や OpenGL などをパッケージングしたもののようです。 (詳細はこちら → " (a (@ (href "http://practical-scheme.net/wiliki/wiliki.cgi?Gauche%3aGauchebox")) "WiLiKi") " / " (a (@ (href "http://sourceforge.net/project/showfiles.php?group_id=25227")) "ダウンロード") ")")
							(li (span (@ (class "date")) "2008/06/16(MON)") " : Ypsilon Version 0.9.5 がリリースされました。 (詳細はこちら → " (a (@ (href "http://www.littlewingpinball.com/contents/ja/ypsilon.html")) "プロジェクトホームページ") " / " (a (@ (href "http://code.google.com/p/ypsilon/")) "ダウンロード") " / " (a (@ (href "http://lwpinball.wordpress.com/2008/06/16/%e3%82%8f%e3%81%9f%e3%81%97%e3%81%af%e3%82%b9%e3%83%88%e3%83%a9%e3%83%88%e3%82%b9%e4%b8%96%e4%bb%a3%e3%81%a7%e3%82%82%e3%81%82%e3%82%8b%e3%82%93%e3%81%a0%e3%81%91%e3%81%a9%e3%83%bb%e3%83%bb%e3%83%bb/")) "ブログ記事") " / " (a (@ (href "http://groups.google.com/group/comp.lang.scheme/browse_thread/thread/929af95f9d27ef2c")) "ニュースグループ記事") ")")
							(li (span (@ (class "date")) "2008/06/16(MON)") " : 6月21日(土) 午前9時30分より タイムインターメディア にて Gauche Hacks が開催されます。いよいよ Gauche 本第二弾 の執筆開始です。詳細は Gauche メーリングリストアーカイブを参照してください。")
							(li (span (@ (class "date")) "2008/06/14(SAT)") " : 6月14日(土) 午後8時より " (a (@ (href "http://www.lingr.com/room/gKpArxPn9wi")) "Lingr: COMMON LISP 部屋") " にて " (a (@ (href "http://cadr.g.hatena.ne.jp/g000001/20080611/1213134259")) "第3回 慢性的CL勉強会@Lingr 8時だョ!全員集合") " が開催されます。")
							(li (span (@ (class "date")) "2008/06/12(THU)") " : " (a (@ (href "http://www.plt-scheme.org/")) "Plt Scheme") " Version 4.0 が " (a (@ (href "http://blog.plt-scheme.org/2008/06/plt-scheme-version-4.html")) "リリース") " されました。")
							(li (span (@ (class "date")) "2008/06/12(THU)") " : " (a (@ (href "http://code.google.com/p/mosh-scheme/")) "Mosh") " Version 0.0.4 が " (a (@ (href "http://d.hatena.ne.jp/higepon/20080612/1213241790")) "リリース") " されました。サンプルアプリケーションとして " (a (@ (href "http://www.blue.sky.or.jp/grass/doc_ja.html")) "Grass") " 言語のインタプリタが付属しているそうです。")
							(li (span (@ (class "date")) "2008/06/08(SUN)") " : このサイトのリポジトリを " (a (@ (href "http://lambdarepos.org/")) "LambdaRepos") " に設置しました。")
							(li (span (@ (class "date")) "2008/06/07(SAT)") " : 6月7日(土) 午後8時より " (a (@ (href "http://www.lingr.com/room/gKpArxPn9wi")) "Lingr: COMMON LISP 部屋") " にて " (a (@ (href "http://cadr.g.hatena.ne.jp/g000001/20080531/1212235511")) "第2回 突発性CL勉強会@Lingr 8時だョ!全員集合") " が開催されます。")
							(li (span (@ (class "date")) "2008/06/04(WED)") " : " (a (@ (href "http://www.plt-scheme.org/")) "Plt Scheme") " の新バージョン 4.0 が " (a (@ (href "http://blog.plt-scheme.org/2008/06/plt-scheme-version-40-is-coming-soon.html")) "まもなくリリース") " されるようです。")
							(li (span (@ (class "date")) "2008/06/03(TUE)") " : Scheme コミュニティのブログ集 " (a (@ (href "http://scheme-users.jp/planet/")) "Planet Scheme Japan") " を開始しました。" (span (@ (style "color:red;")) "(参加者募集中！)"))
							(li (span (@ (class "date")) "2008/05/30(THU)") " : " "軽量プログラミング言語のイベント " (a (@ (href "http://ll.jus.or.jp/2008/")) "LL Future") " のチケットがローソンチケットにて発売開始しました。")
							(li (span (@ (class "date")) "2008/05/28(WED)") " : " (a (@ (href "http://jp.youtube.com/")) "YouTube") " に " (a (@ (href "http://practical-scheme.net/wiliki/wiliki.cgi?Shiro")) "Shiro") " さんが " (a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche") " について話す " (a (@ (href "http://www.youtube.com/watch?v=WEBOdWyGE3E")) "動画") " が公開されています。")
							(li (span (@ (class "date")) "2008/05/27(TUE)") " : " "Open Tech Press に Scheme 関連記事「" (a (@ (href "http://opentechpress.jp/developer/08/05/27/024252.shtml")) "SCSH (Scheme Shell) スクリプト入門") "」が掲載されています。")
							(li (span (@ (class "date")) "2008/05/25(SUN)") " : " "scheme-users.jp 開設しました。"))

						(table
							(tr
								(td (a (@ (href "http://ll.jus.or.jp/2008/"))
									(img (@ (src "./images/ll2008.jpg") (alt "LL Future : 2008/08/30") (style "border:none;")))))
								(td (a (@ (href "http://www.lingr.com/room/gKpArxPn9wi"))
									(img (@ (src "./images/clpm8.png") (alt "慢性的CL勉強会@Lingr８時だョ！全員集合") (style "border:none;"))))))
							(tr
								(td (@ (style "text-align:center;")) "LL Future : 2008/08/30")
								(td (@ (style "text-align:center;")) "CL勉強会@Lingr : 次回 7/26 (土) PM8" (br) "Common Lisp Cookbook")))

						(h2 "Lisp/Scheme チャット")
						(ul
							(li (a (@ (href "irc://irc.freenode.net/Lisp_Scheme")) "irc.freenode.net#Lisp_Scheme") " (UTF-8) : Common Lisp や Arc など他の Lisp の話題もあります。"))

						(h2 (a (@ (href "http://scheme-users.jp/planet/")) "Planet Scheme Japan"))
						(p (a (@ (href "http://scheme.dk/planet/")) "Planet Scheme")
							" の " (a (@ (href "http://scheme-users.jp/planet/")) "日本版")
							" を作りたいと考えています。参加者募集中です！"
							" Scheme について書いたブログならどなたでも参加できます。")
						(ul
							(li (a (@ (href "http://d.hatena.ne.jp/higepon/")) "ひげぽん OS とか作っちゃうか Mona-"))
							(li (a (@ (href "http://cadr.g.hatena.ne.jp/g000001/")) "わだば Lisper になる")))

						(h2 "日本でよく使われている処理系")
						(ul
							(li (a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche"))
							(li (a (@ (href "http://code.google.com/p/sigscheme/")) "SigScheme"))
							(li (a (@ (href "http://www.plt-scheme.org/")) "Plt Scheme") " / " (a (@ (href "http://www.plt-scheme.org/software/drscheme/")) "DrScheme") " / " (a (@ (href "http://www.plt-scheme.org/software/mzscheme/")) "MzScheme"))
							(li (a (@ (href "http://www.gnu.org/software/guile/")) "GNU Guile"))
							(li (a (@ (href "http://www.gnu.org/software/mit-scheme/")) "MIT/GNU Scheme"))
							(li (a (@ (href "http://code.google.com/p/mosh-scheme/")) "Mosh") " : " (a (@ (href "http://d.hatena.ne.jp/higepon/")) "higepon") " 氏が新しく作りはじめた処理系。期待しましょう :-)")
							(li (a (@ (href "http://code.google.com/p/ypsilon/")) "Ypsilon") " : !!!?"))

						(h2 "初心者向け学習サイト")
						(ul
							(li (a (@ (href "http://www.shido.info/lisp/idx_scm.html")) "もうひとつの Scheme 入門"))
							(li (a (@ (href "http://www.unixuser.org/~euske/doc/scm-sd7/")) "Scheme プログラミング入門"))
							(li (a (@ (href "http://www1.ocn.ne.jp/~scheme/scheme-start.html")) "まったく初めての人のための Scheme"))
							(li (a (@ (href "http://www.stdio.h.kyoto-u.ac.jp/~hioki/gairon-enshuu/SchemeNotes/scheme.html")) "Scheme への道"))
							(li (a (@ (href "http://karetta.jp/book-cover/gauche-hacks")) "Gaucheプログラミング(立読み版)"))
							(li (a (@ (href "http://www.ccs.neu.edu/home/dorai/t-y-scheme/t-y-scheme.html")) "Teach Yourself Scheme in Fixnum Days")
								" / " (a (@ (href "http://www.sampou.org/scheme/t-y-scheme/t-y-scheme.html")) "独習 Scheme 三週間"))
							(li (a (@ (href "http://www.htdp.org/")) "How to Design Programs"))
							(li "[Think IT] Gauche でプログラミング！")
							(ul
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/1/")) "第 1 回 Gauche をはじめてみませんか？"))
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/2/")) "第 2 回 超！ Gauche 入門"))
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/3/")) "第 3 回 簡単 Web プログラミング！"))
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/4/")) "第 4 回 Gauche で超高生産性 Web アプリ！"))
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/5/")) "第 5 回 Gauche で COOL な Web アプリ！"))))

						(h2 "定番サイト")
						(ul
							(li (a (@ (href "http://practical-scheme.net/")) "Practical Scheme"))
							(li (a (@ (href "http://www.kahua.org/")) "Kahua Project"))
							(li (a (@ (href "http://schemers.org/")) "schemers.org"))
							(li (a (@ (href "http://srfi.schemers.org/")) "SRFI - Scheme Requests for Implementation"))
							(li (a (@ (href "http://www.r6rs.org/")) "R6RS - Revised 6 Report on the Algorithmic Language Scheme"))
							(li (a (@ (href "http://swiss.csail.mit.edu/projects/scheme/")) "The Scheme Programming Language"))
							(li (a (@ (href "http://mitpress.mit.edu/sicp/")) "SICP - Structure and Interpretation of Computer Programs"))
							(li (a (@ (href "http://www.scheme.com/tspl3/")) "The Scheme Programming Language Third Edition"))
							(li (a (@ (href "http://www1.ocn.ne.jp/~scheme/")) "やっぱり Scheme だね"))
							(li (a (@ (href "http://lambda.bugyo.tk/hatena/")) "はてなようせいとまなぶ Scheme の形式的意味論"))
							(li (a (@ (href "http://lambda.bugyo.tk/hatena/r5rs.html")) "はてなようせいとまなぶ R5RS の表示的意味論"))
							(li (a (@ (href "http://ja.doukaku.org/lang/scheme/")) "どう書く？org Scheme部"))
							(li (a (@ (href "http://www.math.u-toyama.ac.jp/~iwao/Scheme/scheme.html")) "Algorithmic Language Scheme")))
							;;(li (a (@ (href "http://t-code.org/scheme-aa.html")) "ポルナレフ"))

						(h2 "その他の *-users.jp")
						(ul
							(li (a (@ (href "http://air-users.jp/")) "air-users.jp") " : 日本の AIR ユーザのためのハブサイト")
							(li (a (@ (href "http://arc-users.jp/")) "arc-users.jp") " : 日本の Arc ユーザのためのハブサイト")
							(li (a (@ (href "http://as-users.jp/")) "as-users.jp") " : 日本の ActionScript ユーザのためのハブサイト")
							(li (a (@ (href "http://awk-users.jp/")) "awk-users.jp") " : 日本の AWK ユーザのためのハブサイト")
							(li (a (@ (href "http://c-users.jp/")) "c-users.jp") " : 日本の C/C++ ユーザのためのハブサイト")
							(li (a (@ (href "http://cakephp-users.jp/")) "cakephp-users.jp") " : 日本の cakePHP ユーザのためのハブサイト")
							(li (a (@ (href "http://emacs-users.jp/")) "emacs-users.jp") " : 日本の Emacs ユーザのためのハブサイト")
							(li (a (@ (href "http://erlang-users.jp/")) "erlang-users.jp") " : 日本の Erlang ユーザのためのハブサイト")
							(li (a (@ (href "http://hauhau-users.jp/")) "hauhau-users.jp") " : 日本の はうはう ユーザのためのハブサイト")
							(li (a (@ (href "http://haxe-users.jp/")) "haxe-users.jp") " : 日本の heXe ユーザのためのハブサイト")
							(li (a (@ (href "http://hsp-users.jp")) "hsp-users.jp") " : 日本の HSP ユーザのためのハブサイト")
							(li (a (@ (href "http://io-users.jp/")) "io-users.jp") " : 日本の Io ユーザのためのハブサイト")
							(li (a (@ (href "http://js-users.jp/")) "js-users.jp") " : 日本の JavaScript ユーザのためのハブサイト")
							(li (a (@ (href "http://perl-users.jp/")) "perl-users.jp") " : 日本の Perl ユーザのためのハブサイト")
							(li (a (@ (href "http://php-users.jp/")) "php-users.jp") " : 日本の PHP ユーザのためのハブサイト")
							(li (a (@ (href "http://php5-users.jp/")) "php5-users.jp") " : 日本の PHP5 ユーザのためのハブサイト")
							(li (a (@ (href "http://pyobjc-users.jp/")) "pyobjc-users.jp") " : 日本の PyObjC ユーザのためのハブサイト")
							(li (a (@ (href "http://python-users.jp/")) "python-users.jp") " : 日本の Python ユーザのためのハブサイト")
							(li (a (@ (href "http://rails-users.jp/")) "rails-users.jp") " : 日本の Rails ユーザのためのハブサイト")
							(li (a (@ (href "http://vim-users.jp/")) "vim-users.jp") " : 日本の Vim ユーザのためのハブサイト"))

						(h3 "管理人")
						(p "このサイトは "
							(a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche") " の "
							(a (@ (href "http://practical-scheme.net/gauche/man/gauche-refj_148.html")) "sxml.serializer") " を使って生成しています。"
							(br)
							"コードは " (a (@ (href "http://lambdarepos.org/")) "LambdaRepos") " の Subversion にて管理しています。"
							(a (@ (href "http://lambdarepos.org/")) "LambdaRepos") " の Committer である関数型言語ハッカーならどなたでも書き換える事が出来ます。")
						(p "なにかあれば何らかの手段で "
							"(string-append \"info\" \"@\" \"scheme-users.jp\")"
							" まで連絡ください。")
						(p "文章のライセンスは、特に明記が無い限り全て "
							(abbr (@ (title "Creative Commons Attribution license")) "CC-by")
							" でお願いします。"))) out)
			(newline out)))))
