(use srfi-1)
(use srfi-19)
(use sxml.serializer)

(define lambda-news (lambda ()
	(call-with-input-file "news.dat"
		(lambda (in)
			(let ((news (read in)))
				(map (lambda (ns)
					(let ((y (list-ref (car ns) 0))
							(m (list-ref (car ns) 1))
							(d (list-ref (car ns) 2))
							(h (list-ref (car ns) 3))
							(i (list-ref (car ns) 4))
							(s 1))
						(let ((dt (make-date 0 s i h d m y 0)))
							`(entry
								(title ,(date->string dt "~Y/~m/~d(~a)"))
								(id ,(string-append "http://scheme-users.jp/index.html#news" (date->string dt "~Y~m~d~H~M~S")))
								(link (@ (href ,(string-append "http://scheme-users.jp/index.html#news" (date->string dt "~Y~m~d~H~M~S")))))
								(updated ,(date->string dt "~Y-~m-~dT~H:~M:~SZ"))
								(content (@ (type "html"))
									,(call-with-output-string
										(lambda (out)
											(srl:sxml->xml (cons 'p (cdr ns)) out))))))))
					(take news 20)))))))

(define main (lambda (args)
	(srl:parameterizable
		`(feed (@ (xmlns "http://www.w3.org/2005/Atom"))
			(title "Scheme-users.jp")
			(link (@ (href "http://scheme-users.jp/")))
			(updated ,(date->string (current-date) "~Y-~m-~dT~H:~M:~SZ"))
			(auther (name "Scheme-users.jp"))
			(id "http://scheme-users.jp/")
			,@(lambda-news))
		"atom.xml"
		'(omit-xml-declaration . #f)
		'(cdata-section-elements . (content)))
	0))
