(use srfi-1) ;; take
(use srfi-19) ;; make-date date->string
(use sxml.serializer)

(define lambda-news (lambda ()
	(call-with-input-file "news.dat"
		(lambda (in)
			(let ((news (read in)))
				(map (lambda (ns)
					(let ((y (list-ref (car ns) 0))
							(m (list-ref (car ns) 1))
							(d (list-ref (car ns) 2))
							(h (list-ref (car ns) 3))
							(i (list-ref (car ns) 4))
							(s 1))
						(let ((dt (make-date 0 s i h d m y 0)))
							`(li (@ (id ,(string-append "news" (date->string dt "~Y~m~d~H~M~S"))))
								(span (@ (class "date")) ,(date->string dt "~Y/~m/~d(~a)"))
								" : " ,@(cdr ns)))))
					(take news 20)))))))

(define main (lambda (args)
	(call-with-output-file "index.html"
		(lambda (out)
			(display "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" out)
			(newline out)
			(display "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"" out)
			(newline out)
			(display "\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">" out)
			(newline out)
			(srl:sxml->xml
				`(html (@ (xmlns "http://www.w3.org/1999/xhtml") (xml:lang "ja"))
					(head
						(meta (@ (http-equiv "Content-Type") (content "text/html; charset=UTF-8")))
						(meta (@ (http-equiv "Content-Language") (content "ja")))
						(meta (@ (name "keywords") (content "Scheme")))
						(meta (@ (name "description") (content "日本の Scheme ユーザのためのハブサイト。日々 Scheme 情報を発信しています。")))
						(link (@ (rel "shortcut icon") (href "favicon.ico") (type "image/x-icon")))
						(link (@ (rel "stylesheet") (type "text/css") (href "index.css")))
						(link (@ (rel "alternate") (type "application/atom+xml") (title "Scheme-users.jp Atom Feed") (href "http://scheme-users.jp/atom.xml")))
						(title "Scheme-users.jp - 日本の Scheme ユーザのためのハブサイト")
						(script (@ (type "text/javascript") (src "comment.js")) "/* comment.js */"))
					(body
						(p (@ (style "margin-left:0;"))
							(a (@ (href "http://scheme-users.jp/"))
								(img (@ (src "./images/top.png") (alt "scheme-users.jp") (style "border:none;")))))

						(h1 "日本の Scheme ユーザのためのハブサイト")

						(p (a (@ (href "http://conferences.yapcasia.org/ya2008/") (title "YAPC::Asia 2008 - May 15-16th in Tokyo, JAPAN")) "YAPC::Asia 2008")
							" で " (a (@ (href "http://conferences.yapcasia.org/ya2008/user/780") (title "ユーザ情報: YAPC::Asia 2008 - May 15-16th in Tokyo, JAPAN")) "Michael Schwern")
							" は「SEO に有効な独自ドメインを取って、もっと Perl 初心者が集まりやすい nice な Perl の情報を集めたサイトを作れ！」といったそうです。"
							"そして「" (a (@ (href "http://perl-users.jp")) "Perl-users.jp - 日本のPerlユーザのためのハブサイト") "」ができました。")
						(p "これは " (strong "Scheme") " も同じではないのか？"
							"そう思って scheme-users.jp ドメインを取り、ここに scheme-users.jp を開始します。"
							"完全に perl-users.jp とか js-users.jp とか as-users.jp とかにインスパイアされています。"
							"本当にありがとうございます。" "ノープランです。")

						(h2 "ポリシー的な物")
						(ul
							(li "日本語とＳ式で語り合う。")
							(li "このサイトの想定する利用者層は、超初心者から超上級者まで。")
							(li "たとえば " (a (@ (href "http://www.r6rs.org/")) "R6RS")
								" で、いきなり言語仕様が変更されたとしても、"
								"しっかり初心者層にリーチし、最新のトレンドに近づけるように。")
							(li "Users ってついてるけど、日本人は Users ってついてるものが好きだからという理由だけなので "
								(a (@ (href "http://schemers.org/")) "schemers.org") " とか "
								(a (@ (href "http://practical-scheme.net/wiliki/wiliki.cgi")) "WiLiKi")
								" とかそういうのと競合になるとかスピンアウトしたとかそういうのではありません。"
								"レイヤーが違います。"))

						(h2 (a (@ (href "news.html")) "LAMBDA NEWS") " "
							(span (@ (style "font-size:10pt; font-weight:normal; color:red;"))
								"(" (a (@ (style "color:#FF8888;") (onclick "comment()")) "情報募集中！") ")"))
						(ul ,@(lambda-news))

						(table (@ (style "margin:10px auto;"))
							(tr
								(td (a (@ (href "http://shibuya.lisp-users.org/"))
									(img (@ (src "./images/shibuya-lisp.png") (alt "Shibuya.lisp") (style "border:none;")))))
								(td (a (@ (href "http://www.lingr.com/room/common-lisp-jp"))
									(img (@ (src "./images/clpm8.png") (alt "慢性的CL勉強会@Lingr８時だョ！全員集合") (style "border:none;"))))))
							(tr
								(td (@ (style "text-align:center;")) (a (@ (href "http://tips.lisp-users.org/scheme/")) "逆引きScheme") " 作成中！")
								(td (@ (style "text-align:center;")) "CL勉強会@Lingr 次回 : 11月22日(土) 午後８時" (br) "お題 : 『" (a (@ (href "http://common-lisp.net/project/metatilities/")) "Metatilities") " を読む』")))

						(h2 "Scheme チャット")
						(ul
							(li (a (@ (href "irc://irc.freenode.net/Lisp_Scheme")) "irc.freenode.net#Lisp_Scheme") " (UTF-8) : Common Lisp や Arc など他の Lisp の話題もあります。[" (a (@ (href "http://lambdarepos.org/kaela/")) "過去ログ") "]")
							(li (a (@ (href "http://www.lingr.com/room/gauche")) "Gauche (at Lingr)") " : [" (a (@ (href "http://www.lingr.com/room/gauche/archives")) "過去ログ") "]")
							(li (a (@ (href "http://wassr.jp/channel/lisp")) "Wassr LISP チャンネル") " : ")
							(li (a (@ (href "http://wassr.jp/channel/gauche")) "Wassr Gauche チャンネル") " : みんな大好き Gauche"))

						(h2 "Scheme コミュニティ")
						(ul
							(li (a (@ (href "http://shibuya.lisp-users.org/")) "Shibuya.lisp"))
							(li (a (@ (href "http://www.kahua.org/")) "Kahua Project")))

						(h2 (a (@ (href "http://scheme-users.jp/planet/")) "Planet Scheme Japan"))
						(p (a (@ (href "http://scheme.dk/planet/")) "Planet Scheme")
							" の " (a (@ (href "http://scheme-users.jp/planet/")) "日本版")
							" を作りたいと考えています。参加者募集中です！"
							" Scheme について書いたブログならどなたでも参加できます。")
						(ul
							(li (a (@ (href "http://d.hatena.ne.jp/higepon/")) "ひげぽん OS とか作っちゃうか Mona-") " [" (a (@ (href "http://d.hatena.ne.jp/higepon/rss2")) "RSS") "]")
							(li (a (@ (href "http://cadr.g.hatena.ne.jp/g000001/")) "わだば Lisper になる") " [" (a (@ (href "http://cadr.g.hatena.ne.jp/g000001/rss2")) "RSS") "]")
							(li (a (@ (href "http://blog.livedoor.jp/naoya_t/")) "柴ログ") " [" (a (@ (href "http://blog.livedoor.jp/naoya_t/index.rdf")) "RSS") "]")
							(li (a (@ (href "http://d.hatena.ne.jp/fujita-y/")) "Y.FUJITA::NOTEPAD::YPSILON") " [" (a (@ (href "http://d.hatena.ne.jp/fujita-y/rss2")) "RSS") "]"))

						(h2 "日本でよく使われている処理系")
						(ul
							(li (a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche") " : " (a (@ (href "http://practical-scheme.net/wiliki/wiliki.cgi?Shiro")) "Shiro") " さんが開発している処理系。ライブラリとドキュメントが充実。はじめての方はまずは " (a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche") " を使いましょう。")
							(li (a (@ (href "http://code.google.com/p/ypsilon/")) "Ypsilon") " : ピンボールゲームで有名な " (a (@ (href "http://www.littlewingpinball.com/")) "LittleWing") " で開発されている高性能な R6RS 処理系。")
							(li (a (@ (href "http://code.google.com/p/mosh-scheme/")) "Mosh") " : " (a (@ (href "http://www.monaos.org/")) "MonaOS") " の開発者の " (a (@ (href "http://d.hatena.ne.jp/higepon/")) "Higepon") " さんが新しく作りはじめた処理系。期待しましょう :-)")
							(li (a (@ (href "http://code.google.com/p/sigscheme/")) "SigScheme") " : " (a (@ (href "http://code.google.com/p/uim/")) "uim") " のために作られた R5RS 処理系。")
							;;(li (a (@ (href "http://mono.kmc.gr.jp/~yhara/w/?BiwaScheme")) "BiwaScheme") " : JavaScript で作られた処理系。")
							(li (a (@ (href "http://www.plt-scheme.org/")) "Plt Scheme") " : 世界的に利用されている高性能な Scheme インタプリタ。グラフィカルな開発環境が付属している。")
							(li (a (@ (href "http://www.gnu.org/software/guile/")) "GNU Guile") " : " (a (@ (href "http://www.gnu.org/")) "GNU Project") " で開発されている処理系。")
							(li (a (@ (href "http://www.gnu.org/software/mit-scheme/")) "MIT/GNU Scheme") " : Scheme の故郷 MIT で開発されている処理系。"))

						(h2 "初心者向け学習サイト")
						(ul
							(li (a (@ (href "http://www.shido.info/lisp/idx_scm.html")) "もうひとつの Scheme 入門"))
							(li (a (@ (href "http://www.unixuser.org/~euske/doc/scm-sd7/")) "Scheme プログラミング入門"))
							(li (a (@ (href "http://www1.ocn.ne.jp/~scheme/scheme-start.html")) "まったく初めての人のための Scheme"))
							(li (a (@ (href "http://www.stdio.h.kyoto-u.ac.jp/~hioki/gairon-enshuu/SchemeNotes/scheme.html")) "Scheme への道"))
							(li (a (@ (href "http://karetta.jp/book-cover/gauche-hacks")) "Gaucheプログラミング(立読み版)"))
							(li (a (@ (href "http://www.ccs.neu.edu/home/dorai/t-y-scheme/t-y-scheme.html")) "Teach Yourself Scheme in Fixnum Days")
								" / " (a (@ (href "http://www.sampou.org/scheme/t-y-scheme/t-y-scheme.html")) "独習 Scheme 三週間"))
							(li (a (@ (href "http://www.htdp.org/")) "How to Design Programs"))
							(li "[Think IT] Gauche でプログラミング！")
							(ul
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/1/")) "第 1 回 Gauche をはじめてみませんか？"))
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/2/")) "第 2 回 超！ Gauche 入門"))
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/3/")) "第 3 回 簡単 Web プログラミング！"))
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/4/")) "第 4 回 Gauche で超高生産性 Web アプリ！"))
								(li (a (@ (href "http://www.thinkit.co.jp/article/74/5/")) "第 5 回 Gauche で COOL な Web アプリ！"))))

						(h2 "定番サイト")
						(ul
							(li (a (@ (href "http://practical-scheme.net/")) "Practical Scheme") " | " (a (@ (href "http://practical-scheme.net/wiliki/wiliki.cgi")) "WiLiKi"))
							(li (a (@ (href "http://schemers.org/")) "schemers.org"))
							(li (a (@ (href "http://srfi.schemers.org/")) "SRFI - Scheme Requests for Implementation"))
							(li (a (@ (href "http://www.schemers.org/Documents/Standards/R5RS/")) "R5RS - Revised 5 Report on the Algorithmic Language Scheme"))
							(li (a (@ (href "http://www.r6rs.org/")) "R6RS - Revised 6 Report on the Algorithmic Language Scheme"))
							(li (a (@ (href "http://swiss.csail.mit.edu/projects/scheme/")) "The Scheme Programming Language"))
							(li (a (@ (href "http://mitpress.mit.edu/sicp/")) "SICP - Structure and Interpretation of Computer Programs"))
							(li (a (@ (href "http://www.scheme.com/tspl3/")) "The Scheme Programming Language Third Edition"))
							(li (a (@ (href "http://www1.ocn.ne.jp/~scheme/")) "やっぱり Scheme だね"))
							(li (a (@ (href "http://lambda.bugyo.tk/hatena/")) "はてなようせいとまなぶ Scheme の形式的意味論"))
							(li (a (@ (href "http://lambda.bugyo.tk/hatena/r5rs.html")) "はてなようせいとまなぶ R5RS の表示的意味論"))
							(li (a (@ (href "http://ja.doukaku.org/lang/scheme/")) "どう書く？org Scheme部"))
							(li (a (@ (href "http://www.math.u-toyama.ac.jp/~iwao/Scheme/scheme.html")) "Algorithmic Language Scheme"))
							(li (a (@ (href "http://groups.google.co.jp/group/comp.lang.scheme")) "comp.lang.scheme"))
							(li (a (@ (href "https://www.google.com/calendar/embed?src=fvijvohm91uifvd9hratehf65k%40group.calendar.google.com")) "IT勉強会カレンダー")))
							;;(li (a (@ (href "http://t-code.org/scheme-aa.html")) "ポルナレフ"))

						(h2 "その他の *-users.jp")
						(ul
							(li (a (@ (href "http://air-users.jp/")) "air-users.jp") " : 日本の AIR ユーザのためのハブサイト")
							(li (a (@ (href "http://arc-users.jp/")) "arc-users.jp") " : 日本の Arc ユーザのためのハブサイト")
							(li (a (@ (href "http://as-users.jp/")) "as-users.jp") " : 日本の ActionScript ユーザのためのハブサイト")
							(li (a (@ (href "http://awk-users.jp/")) "awk-users.jp") " : 日本の AWK ユーザのためのハブサイト")
							(li (a (@ (href "http://c-users.jp/")) "c-users.jp") " : 日本の C/C++ ユーザのためのハブサイト")
							(li (a (@ (href "http://cakephp-users.jp/")) "cakephp-users.jp") " : 日本の cakePHP ユーザのためのハブサイト")
							(li (a (@ (href "http://emacs-users.jp/")) "emacs-users.jp") " : 日本の Emacs ユーザのためのハブサイト")
							(li (a (@ (href "http://erlang-users.jp/")) "erlang-users.jp") " : 日本の Erlang ユーザのためのハブサイト")
							(li (a (@ (href "http://hauhau-users.jp/")) "hauhau-users.jp") " : 日本の はうはう ユーザのためのハブサイト")
							(li (a (@ (href "http://haxe-users.jp/")) "haxe-users.jp") " : 日本の heXe ユーザのためのハブサイト")
							(li (a (@ (href "http://hsp-users.jp")) "hsp-users.jp") " : 日本の HSP ユーザのためのハブサイト")
							(li (a (@ (href "http://io-users.jp/")) "io-users.jp") " : 日本の Io ユーザのためのハブサイト")
							(li (a (@ (href "http://js-users.jp/")) "js-users.jp") " : 日本の JavaScript ユーザのためのハブサイト")
							(li (a (@ (href "http://perl-users.jp/")) "perl-users.jp") " : 日本の Perl ユーザのためのハブサイト")
							(li (a (@ (href "http://php-users.jp/")) "php-users.jp") " : 日本の PHP ユーザのためのハブサイト")
							(li (a (@ (href "http://php5-users.jp/")) "php5-users.jp") " : 日本の PHP5 ユーザのためのハブサイト")
							(li (a (@ (href "http://pyobjc-users.jp/")) "pyobjc-users.jp") " : 日本の PyObjC ユーザのためのハブサイト")
							(li (a (@ (href "http://python-users.jp/")) "python-users.jp") " : 日本の Python ユーザのためのハブサイト")
							(li (a (@ (href "http://rails-users.jp/")) "rails-users.jp") " : 日本の Rails ユーザのためのハブサイト")
							(li (a (@ (href "http://smalltalk-users.jp/")) "smalltalk-users.jp") " : 日本の Smalltalk ユーザのためのハブサイト")
							(li (a (@ (href "http://vim-users.jp/")) "vim-users.jp") " : 日本の Vim ユーザのためのハブサイト"))

						(h3 "管理人")
						(p "このサイトは "
							(a (@ (href "http://practical-scheme.net/gauche/index-j.html")) "Gauche") " の "
							(a (@ (href "http://practical-scheme.net/gauche/man/gauche-refj_148.html")) "sxml.serializer") " を使って生成しています。"
							(br)
							"コードは " (a (@ (href "http://lambdarepos.org/")) "LambdaRepos") " の Subversion にて管理しています。"
							(a (@ (href "http://lambdarepos.org/")) "LambdaRepos") " の Committer である関数型言語ハッカーならどなたでも書き換える事が出来ます。")
						(p "なにかあれば何らかの手段で "
							"(string-append \"info\" \"@\" \"scheme-users.jp\")"
							" まで連絡ください。")
						(p "文章のライセンスは、特に明記が無い限り全て "
							(abbr (@ (title "Creative Commons Attribution license")) "CC-by")
							" でお願いします。")))
				out)
			(newline out)))
	0))
