(use srfi-19) ;; make-date date->string
(use sxml.serializer)

(define lambda-news (lambda ()
	(call-with-input-file "news.dat"
		(lambda (in)
			(let ((news (read in)))
				(map (lambda (ns)
					(let ((y (list-ref (car ns) 0))
							(m (list-ref (car ns) 1))
							(d (list-ref (car ns) 2))
							(h (list-ref (car ns) 3))
							(i (list-ref (car ns) 4))
							(s 1))
						(let ((dt (make-date 0 s i h d m y 0)))
							`(li (@ (id ,(string-append "news" (date->string dt "~Y~m~d~H~M~S"))))
								(span (@ (class "date")) ,(date->string dt "~Y/~m/~d(~a)"))
								" : " ,@(cdr ns)))))
					news))))))

(define main (lambda (args)
	(call-with-output-file "news.html"
		(lambda (out)
			(display "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" out)
			(newline out)
			(display "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"" out)
			(newline out)
			(display "\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">" out)
			(newline out)
			(srl:sxml->xml
				`(html (@ (xmlns "http://www.w3.org/1999/xhtml") (xml:lang "ja"))
					(head
						(meta (@ (http-equiv "Content-Type") (content "text/html; charset=UTF-8")))
						(meta (@ (http-equiv "Content-Language") (content "ja")))
						(meta (@ (name "keywords") (content "Scheme,Lisp,Lambda,NEWS")))
						(meta (@ (name "description") (content "LAMBDA NEWS - Scheme/Lisp 界の日々の記録。")))
						(link (@ (rel "shortcut icon") (href "favicon.ico") (type "image/x-icon")))
						(link (@ (rel "stylesheet") (type "text/css") (href "index.css")))
						(link (@ (rel "alternate") (type "application/atom+xml") (title "Scheme-users.jp Atom Feed") (href "http://scheme-users.jp/atom.xml")))
						(title "LAMBDA NEWS - Scheme-users.jp"))
					(body
						(p (@ (style "margin-left:0;"))
							(a (@ (href "http://scheme-users.jp/"))
								(img (@ (src "./images/top.png") (alt "scheme-users.jp") (style "border:none;")))))
						(h1 "LAMBDA NEWS")
						(ul ,@(lambda-news))))
				out)
			(newline out)))
	0))
